capt program drop CI1D
program define CI1D, eclass

version 11.0

** This program uses the nonparametric bootstrap described in Beresteanu and
** Molinari (2008) Algorithm 4.2.  The bracketing is done the way Chernozukov, 
** Hong and Tamer describe in their paper: section 4.5 of CHT (2004). 

syntax varlist (min=2 default=none) [, noINTercept REPS(integer 50) LEVel(real .95) noCC noDU TESTnull(namelist min=1 max=1) PREDict(namelist min=1 max=1) CONtrast(namelist min=1 max=1)]
tokenize `varlist'
qui {

** Find Projection **
noi oneDproj `varlist', `intercept' pred(`predict') con(`contrast')
matrix define Thetahat1D = e(Thetahat1D)
if "`predict'" != "" {
	matrix define ThetahatPred = e(ThetahatPred)
}
if "`contrast'" != "" {
	matrix define ThetahatPredCon = e(ThetahatPredCon)
}

local rows = rowsof(Thetahat1D)

count if `1' != . 
local nobs = r(N)

** Find Hausdorff and Directed Hausdorff between Null Set and Estimated Identification Set **
if "`testnull'" != "" {
	confirm matrix `testnull'
	if _rc != 0 {
		di as error "Null set to be tested is not defined as a matrix"
		exit
	}
	matrix ZZZZZ = `testnull'
	capture assert colsof(ZZZZZ) == 2
	if _rc != 0 {
		di as error "Null set has incorrect dimensions, please provide a `rows'x2 matrix"
		exit
	}	
	capture assert rowsof(ZZZZZ) == `rows'
	if _rc != 0 {
		di as error "Null set has incorrect dimensions, please provide a `rows'x2 matrix"
		exit
	}
	forvalues i = 1/`rows' {
		local lb_test = ZZZZZ[`i',1]
		local ub_test = ZZZZZ[`i',2]
	
		capture assert `lb_test' <= `ub_test'
		if _rc != 0 {
			di as error "Elements in column 1 of null set should be lower value and elements in column 2 should be upper value"
			exit
		}
	}
	
	matrix H_true = Thetahat1D - ZZZZZ
	mata H_true = abs(st_matrix("H_true"))
	mata H_true = rowmax(H_true) * sqrt(`nobs')
	mata st_matrix("H_true",H_true)

	matrix dH_true = Thetahat1D - ZZZZZ
	mata dH_true = st_matrix("dH_true")
	mata dH_true[.,2] = -1 * dH_true[.,2] 
	mata dH_true = rowmax(dH_true)
	mata dH_true = (dH_true , J(`rows',1,0))
	mata dH_true = rowmax(dH_true) * sqrt(`nobs')
	mata st_matrix("dH_true",dH_true)
	mata mata drop H_true dH_true
}

** Bootstrapping **
forvalues i = 1/`reps' {
	if `i' == 1 {
		timer clear 1
		timer on 1
		preserve
		bsample `nobs'
	
		oneDproj `varlist', `intercept' pred(`predict') con(`contrast')
		matrix define Thetastar = e(Thetahat1D)
		if "`predict'" != "" {
			matrix define ThetastarPred = e(ThetahatPred)
		}
		if "`contrast'" != "" {
			matrix define ThetastarPredCon = e(ThetahatPredCon)
		}
		
		matrix H_boot = Thetastar - Thetahat1D
		mata H_boot = abs(st_matrix("H_boot"))
		mata H_boot = rowmax(H_boot) * sqrt(`nobs')
		mata st_matrix("H_boot",H_boot)

		matrix dH_boot = Thetastar - Thetahat1D
		mata dH_boot = st_matrix("dH_boot")
		mata dH_boot[.,2] = -1 * dH_boot[.,2] 
		mata dH_boot = rowmax(dH_boot)
		mata dH_boot = (dH_boot , J(`rows',1,0))
		mata dH_boot = rowmax(dH_boot) * sqrt(`nobs')
		mata st_matrix("dH_boot",dH_boot)
		
		matrix dH_boot = dH_boot'
		matrix H_boot = H_boot'
		mata mata drop H_boot dH_boot 
		matrix H = H_boot
		matrix dH = dH_boot
		matrix drop H_boot dH_boot
		
		if "`predict'" != "" {
			matrix H_boot_pred = ThetastarPred - ThetahatPred
			mata H_boot_pred = abs(st_matrix("H_boot_pred"))
			mata H_boot_pred = rowmax(H_boot_pred) * sqrt(`nobs')
			mata st_matrix("H_boot_pred",H_boot_pred)
			
			matrix dH_boot_pred = ThetastarPred - ThetahatPred
			mata dH_boot_pred = st_matrix("dH_boot_pred")
			
			mata dH_boot_pred[.,2] = -1 * dH_boot_pred[.,2] 
			mata dH_boot_pred = rowmax(dH_boot_pred)
			mata dH_boot_pred = (dH_boot_pred , J(1,1,0))
			mata dH_boot_pred = rowmax(dH_boot_pred) * sqrt(`nobs')
			mata st_matrix("dH_boot_pred",dH_boot_pred)		
			
			matrix dH_boot_pred = dH_boot_pred'
			matrix H_boot_pred = H_boot_pred'
			mata mata drop dH_boot_pred H_boot_pred
			matrix H_pred = H_boot_pred 
			matrix dH_pred = dH_boot_pred 
			matrix drop dH_boot_pred H_boot_pred
		}
		
		if "`contrast'" != "" {
			matrix H_boot_pred_con = ThetastarPredCon - ThetahatPredCon
			mata H_boot_pred_con = abs(st_matrix("H_boot_pred_con"))
			mata H_boot_pred_con = rowmax(H_boot_pred_con) * sqrt(`nobs')
			mata st_matrix("H_boot_pred_con",H_boot_pred_con)

			matrix dH_boot_pred_con = ThetastarPredCon - ThetahatPredCon
			mata dH_boot_pred_con = st_matrix("dH_boot_pred_con")
			mata dH_boot_pred_con[.,2] = -1 * dH_boot_pred_con[.,2] 
			mata dH_boot_pred_con = rowmax(dH_boot_pred_con)
			mata dH_boot_pred_con = (dH_boot_pred_con , J(1,1,0))
			mata dH_boot_pred_con = rowmax(dH_boot_pred_con) * sqrt(`nobs')
			mata st_matrix("dH_boot_pred_con",dH_boot_pred_con)	
			
			matrix dH_boot_pred_con = dH_boot_pred_con'
			matrix H_boot_pred_con = H_boot_pred_con'
			mata mata drop dH_boot_pred_con H_boot_pred_con
			matrix H_pred_con = H_boot_pred_con 
			matrix dH_pred_con = dH_boot_pred_con
			matrix drop dH_boot_pred_con H_boot_pred_con
		}

		restore
		timer off 1
		timer list
		noi disp ""
		noi disp "Estimated time for completion is " round((r(t1)*`reps')/60,.01) " minutes"
	}
	else {
		preserve
		bsample `nobs'
	
		oneDproj `varlist', `intercept' pred(`predict') con(`contrast')
		matrix define Thetastar = e(Thetahat1D)
		if "`predict'" != "" {
			matrix define ThetastarPred = e(ThetahatPred)
		}
		if "`contrast'" != "" {
			matrix define ThetastarPredCon = e(ThetahatPredCon)
		}
		
		matrix H_boot = Thetastar - Thetahat1D
		mata H_boot = abs(st_matrix("H_boot"))
		mata H_boot = rowmax(H_boot) * sqrt(`nobs')
		mata st_matrix("H_boot",H_boot)

		matrix dH_boot = Thetastar - Thetahat1D
		mata dH_boot = st_matrix("dH_boot")
		mata dH_boot[.,2] = -1 * dH_boot[.,2] 
		mata dH_boot = rowmax(dH_boot)
		mata dH_boot = (dH_boot , J(`rows',1,0))
		mata dH_boot = rowmax(dH_boot) * sqrt(`nobs')
		mata st_matrix("dH_boot",dH_boot)
		
		matrix dH_boot = dH_boot'
		matrix H_boot = H_boot'
		mata mata drop H_boot dH_boot 
		matrix H = H\H_boot
		matrix dH = dH\dH_boot
		matrix drop H_boot dH_boot
		
		if "`predict'" != "" {
			matrix H_boot_pred = ThetastarPred - ThetahatPred
			mata H_boot_pred = abs(st_matrix("H_boot_pred"))
			mata H_boot_pred = rowmax(H_boot_pred) * sqrt(`nobs')
			mata st_matrix("H_boot_pred",H_boot_pred)
			
			matrix dH_boot_pred = ThetastarPred - ThetahatPred
			mata dH_boot_pred = st_matrix("dH_boot_pred")
			mata dH_boot_pred[.,2] = -1 * dH_boot_pred[.,2] 
			mata dH_boot_pred = rowmax(dH_boot_pred)
			mata dH_boot_pred = (dH_boot_pred , J(1,1,0))
			mata dH_boot_pred = rowmax(dH_boot_pred) * sqrt(`nobs')
			mata st_matrix("dH_boot_pred",dH_boot_pred)		
			
			matrix dH_boot_pred = dH_boot_pred'
			matrix H_boot_pred = H_boot_pred'
			mata mata drop dH_boot_pred H_boot_pred
			matrix H_pred = H_pred\H_boot_pred
			matrix dH_pred = dH_pred\dH_boot_pred
			matrix drop dH_boot_pred H_boot_pred
		}
		
		if "`contrast'" != "" {
			matrix H_boot_pred_con = ThetastarPredCon - ThetahatPredCon
			mata H_boot_pred_con = abs(st_matrix("H_boot_pred_con"))
			mata H_boot_pred_con = rowmax(H_boot_pred_con) * sqrt(`nobs')
			mata st_matrix("H_boot_pred_con",H_boot_pred_con)

			matrix dH_boot_pred_con = ThetastarPredCon - ThetahatPredCon
			mata dH_boot_pred_con = st_matrix("dH_boot_pred_con")
			mata dH_boot_pred_con[.,2] = -1 * dH_boot_pred_con[.,2] 
			mata dH_boot_pred_con = rowmax(dH_boot_pred_con)
			mata dH_boot_pred_con = (dH_boot_pred_con , J(1,1,0))
			mata dH_boot_pred_con = rowmax(dH_boot_pred_con) * sqrt(`nobs')
			mata st_matrix("dH_boot_pred_con",dH_boot_pred_con)	
			
			matrix dH_boot_pred_con = dH_boot_pred_con'
			matrix H_boot_pred_con = H_boot_pred_con'
			mata mata drop dH_boot_pred_con H_boot_pred_con
			matrix H_pred_con = H_pred_con\H_boot_pred_con
			matrix dH_pred_con = dH_pred_con\dH_boot_pred_con
			matrix drop dH_boot_pred_con H_boot_pred_con
		}
		
		restore
	}
}

ereturn clear
ereturn matrix Thetahat1D = Thetahat1D, copy
if "`predict'" != "" {
	ereturn matrix ThetahatPred = ThetahatPred, copy
}
if "`contrast'" != "" {
	ereturn matrix ThetahatPredCon = ThetahatPredCon, copy
}

** Estimate Critical Value **
capt assert `level' > 0 & `level' < 1
if _rc != 0 {
	di as error "Level must be specified between 0 and 1"
	exit
}
local pos = floor(`level'*`reps')
mata cr_H = J(`rows',1,0)
mata cr_dH = J(`rows',1,0)
forvalues j = 1/`rows' {
	mata H = sort(st_matrix("H"),`j')
	mata dH = sort(st_matrix("dH"),`j')
	mata cr_H[`j',1] = H[`pos',`j']
	mata cr_dH[`j',1] = dH[`pos',`j']
}

mata st_matrix("cr_H",cr_H)
mata st_matrix("cr_dH",cr_dH)

ereturn matrix cr_H = cr_H, copy
ereturn matrix cr_dH = cr_dH, copy

noi disp ""
noi disp "Critical Values based on Hausdorff = cr_H  = " 
noi matrix list e(cr_H), noheader nonames
noi disp ""
noi disp "Critical Values based on directed Hausdorff = cr_dH = " 
noi matrix list e(cr_dH), noheader nonames
noi disp ""

if "`predict'" != "" {
	mata cr_H_pred = J(1,1,0)
	mata cr_dH_pred = J(1,1,0)
	mata H_pred = sort(st_matrix("H_pred"),1)
	mata dH_pred = sort(st_matrix("dH_pred"),1)
	mata cr_H_pred[1,1] = H_pred[`pos',1]
	mata cr_dH_pred[1,1] = dH_pred[`pos',1]
	
	mata st_matrix("cr_H_pred",cr_H_pred)
	mata st_matrix("cr_dH_pred",cr_dH_pred)

	ereturn matrix cr_H_pred = cr_H_pred, copy
	ereturn matrix cr_dH_pred = cr_dH_pred, copy

	noi disp ""
	noi disp "Prediction Critical Values based on Hausdorff = cr_H_pred  = " 
	noi matrix list e(cr_H_pred), noheader nonames
	noi disp ""
	noi disp "Prediction Critical Values based on directed Hausdorff = cr_dH_pred = " 
	noi matrix list e(cr_dH_pred), noheader nonames
	noi disp ""
}

if "`contrast'" != "" {
	mata cr_H_pred_con = J(1,1,0)
	mata cr_dH_pred_con = J(1,1,0)
	mata H_pred_con = sort(st_matrix("H_pred_con"),1)
	mata dH_pred_con = sort(st_matrix("dH_pred_con"),1)
	mata cr_H_pred_con[1,1] = H_pred_con[`pos',1]
	mata cr_dH_pred_con[1,1] = dH_pred_con[`pos',1]
	
	mata st_matrix("cr_H_pred_con",cr_H_pred_con)
	mata st_matrix("cr_dH_pred_con",cr_dH_pred_con)

	ereturn matrix cr_H_pred_con = cr_H_pred_con, copy
	ereturn matrix cr_dH_pred_con = cr_dH_pred_con, copy

	noi disp ""
	noi disp "Prediction Contrast Critical Values based on Hausdorff = cr_H_pred_con  = " 
	noi matrix list e(cr_H_pred_con), noheader nonames
	noi disp ""
	noi disp "Prediction Contrast Critical Values based on directed Hausdorff = cr_dH_pred_con = " 
	noi matrix list e(cr_dH_pred_con), noheader nonames
	noi disp ""
}

** Display Test Results **
if "`testnull'" != "" {
	noi disp "Test:"
	forvalues j = 1/`rows' {
		if "`intercept'" != "nointercept" {
			local k = `j' - 1
		}
		if "`intercept'" == "nointercept" {
			local k = `j'
		}
		local H_true = H_true[`j',1]
		local dH_true = dH_true[`j',1]
		local cr_H = cr_H[`j',1]
		local cr_dH = cr_dH[`j',1]

		if `H_true' != . {
			if `H_true' > `cr_H' {
				noi disp "Parameter `k': Hausdorff Distance = " `H_true' " therefore reject the null"
			}
			if `H_true' <= `cr_H' {
				noi disp "Parameter `k': Hausdorff Distance = " `H_true' " therefore fail to reject the null"
			}
			if `dH_true' > `cr_dH' {
				noi disp "Parameter `k': Directed Hausdorff Distance = " `dH_true' " therefore reject the null"
			}
			if `dH_true' <= `cr_dH' {
				noi disp "Parameter `k': Directed Hausdorff Distance = " `dH_true' " therefore fail to reject the null"
			}
		}
	}
	capt matrix drop H_true dH_true ZZZZZ
}

** CC and DU **
if "`cc'" != "nocc" {
	noi disp ""
	noi disp "CC:"
	matrix CC = J(`rows',4,0)
	forvalues j = 1/`rows' {
		if "`intercept'" != "nointercept" {
			local k = `j' - 1
		}
		if "`intercept'" == "nointercept" {
			local k = `j'
		}	
		local CC1 = Thetahat1D[`j',1] - (cr_H[`j',1]/sqrt(`nobs'))
		local CC2 = Thetahat1D[`j',1] + (cr_H[`j',1]/sqrt(`nobs'))
		local CC3 = Thetahat1D[`j',2] - (cr_H[`j',1]/sqrt(`nobs'))
		local CC4 = Thetahat1D[`j',2] + (cr_H[`j',1]/sqrt(`nobs'))
		matrix CC[`j',1] = `CC1'
		matrix CC[`j',2] = `CC2'
		matrix CC[`j',3] = `CC3'
		matrix CC[`j',4] = `CC4'

		noi disp "Parameter `k': Confidence Collection based on Hausdorff, Lower = [" `CC1' " , " `CC2' "]"
		noi disp "Parameter `k': Confidence Collection based on Hausdorff, Upper = [" `CC3' " , " `CC4' "]"
	}
	ereturn matrix CC = CC

	if "`predict'" != "" {
		noi disp ""
		matrix CC_pred = J(1,4,0)
		local CC1 = ThetahatPred[1,1] - (cr_H_pred[1,1]/sqrt(`nobs'))
		local CC2 = ThetahatPred[1,1] + (cr_H_pred[1,1]/sqrt(`nobs'))
		local CC3 = ThetahatPred[1,2] - (cr_H_pred[1,1]/sqrt(`nobs'))
		local CC4 = ThetahatPred[1,2] + (cr_H_pred[1,1]/sqrt(`nobs'))
		matrix CC_pred[1,1] = `CC1'
		matrix CC_pred[1,2] = `CC2'
		matrix CC_pred[1,3] = `CC3'
		matrix CC_pred[1,4] = `CC4'
	
		noi disp "Prediction: Confidence Collection based on Hausdorff, Lower = [" `CC1' " , " `CC2' "]"
		noi disp "Prediction: Confidence Collection based on Hausdorff, Upper = [" `CC3' " , " `CC4' "]"

		ereturn matrix CC_pred = CC_pred
	
	}	

	if "`contrast'" != "" {
		noi disp ""
		matrix CC_pred_con = J(1,4,0)
		local CC1 = ThetahatPredCon[1,1] - (cr_H_pred_con[1,1]/sqrt(`nobs'))
		local CC2 = ThetahatPredCon[1,1] + (cr_H_pred_con[1,1]/sqrt(`nobs'))
		local CC3 = ThetahatPredCon[1,2] - (cr_H_pred_con[1,1]/sqrt(`nobs'))
		local CC4 = ThetahatPredCon[1,2] + (cr_H_pred_con[1,1]/sqrt(`nobs'))
		matrix CC_pred_con[1,1] = `CC1'
		matrix CC_pred_con[1,2] = `CC2'
		matrix CC_pred_con[1,3] = `CC3'
		matrix CC_pred_con[1,4] = `CC4'
	
		noi disp "Prediction Contrast: Confidence Collection based on Hausdorff, Lower = [" `CC1' " , " `CC2' "]"
		noi disp "Prediction Contrast: Confidence Collection based on Hausdorff, Upper = [" `CC3' " , " `CC4' "]"

		ereturn matrix CC_pred_con = CC_pred_con
	
	}
}

if "`du'" != "nodu" {
	noi disp ""
	noi disp "DU:"
	matrix DU = J(`rows',2,0)
	forvalues j = 1/`rows' {
		if "`intercept'" != "nointercept" {
			local k = `j' - 1
		}
		if "`intercept'" == "nointercept" {
			local k = `j'
		}	
		local DU1 = Thetahat1D[`j',1] - (cr_dH[`j',1]/sqrt(`nobs'))
		local DU2 = Thetahat1D[`j',2] + (cr_dH[`j',1]/sqrt(`nobs'))
		matrix DU[`j',1] = `DU1'
		matrix DU[`j',2] = `DU2'

		noi disp "Parameter `k': Confidence Set based on directed Hausdorff = [" `DU1' " , " `DU2' "]"
	}
	ereturn matrix DU = DU

	if "`predict'" != "" {
		noi disp ""
		matrix DU_pred = J(1,2,0)
	
		local DU1 = ThetahatPred[1,1] - (cr_dH_pred[1,1]/sqrt(`nobs'))
		local DU2 = ThetahatPred[1,2] + (cr_dH_pred[1,1]/sqrt(`nobs'))
		matrix DU_pred[1,1] = `DU1'
		matrix DU_pred[1,2] = `DU2'

		noi disp "Prediction: Confidence Set based on directed Hausdorff = [" `DU1' " , " `DU2' "]"
		ereturn matrix DU_pred = DU_pred 	
	
	}
	if "`contrast'" != "" {
		noi disp ""
		matrix DU_pred_con = J(1,2,0)
	
		local DU1 = ThetahatPredCon[1,1] - (cr_dH_pred_con[1,1]/sqrt(`nobs'))
		local DU2 = ThetahatPredCon[1,2] + (cr_dH_pred_con[1,1]/sqrt(`nobs'))
		matrix DU_pred_con[1,1] = `DU1'
		matrix DU_pred_con[1,2] = `DU2'

		noi disp "Prediction Contrast: Confidence Set based on directed Hausdorff = [" `DU1' " , " `DU2' "]"
		ereturn matrix DU_pred_con = DU_pred_con 	
	
	}	
}
	matrix drop Thetastar dH H Thetahat1D cr_H cr_dH 
	if "`predict'" != "" {
		matrix drop ThetastarPred dH_pred H_pred ThetahatPred cr_H_pred cr_dH_pred
	}
	if "`contrast'" != "" {
		matrix drop ThetastarPredCon dH_pred_con H_pred_con ThetahatPredCon cr_H_pred_con cr_dH_pred_con
	}
}
end
